
import java.io.BufferedReader;  
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.*;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.*;

//This is to read the actors data from the csv file

public class DataReader {
	
	//Here the main method will receive the filename of the csv file as an input
	public static void main(String[] args) {
		
		try {
			BufferedReader bufferedReader = new BufferedReader(new FileReader(args[0]));
			bufferedReader.readLine();

			//Storing all the data into a HashMap; Movies are keys and actors are values
			HashMap<String, ArrayList<String>> movies = new HashMap<String, ArrayList<String>>();

			//Storing all actors in a set
			TreeSet<String> actors = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
			JSONParser parser = new JSONParser();
			String line = bufferedReader.readLine();

			//Organizing and indexing data
			while (line != null) {
				int first = line.indexOf(",");
				int second = line.indexOf(",", first+1);
				String movieTitle = line.substring(first+1, second);
				line = line.substring(second+1);
				first = line.indexOf("[");
				int numOpen = 1;

				for (int i = first+1; i < line.length(); i++) {
					if (line.charAt(i) == '[') {
						numOpen++;
					}
					else if (line.charAt(i) == ']' && numOpen == 1) {
							second = i;
							break;
					}
					else if (line.charAt(i) == ']' && numOpen > 1) {
							numOpen--;
					}
					else {
							continue;
					}
				}

				//Making the cast into an array of JSON Strings
				String cast = line.substring(first, second+1);
				cast = cast.replaceAll("\"\"", "\"");
				JSONArray arr = (JSONArray)parser.parse(cast);

				ArrayList<String> movieActors = new ArrayList<String>();
				for (int i = 0; i < arr.size(); i++) {
					JSONObject json = (JSONObject)arr.get(i);
					String actorName = (String)json.get("name");
					movieActors.add(actorName);
					actors.add(actorName);
				}

				movies.put(movieTitle, movieActors);
				line = bufferedReader.readLine();
			}

			bufferedReader.close();

			baconGraph(movies, actors);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	//Method for the HashMap of all the movies and set of actors
	//Will create a graph and do a BFS between the two actors relative to Kevin Bacon
	public static void baconGraph(HashMap<String, ArrayList<String>> movies, TreeSet<String> actors) {
		ActorsGraph graph = new ActorsGraph();
		for (String actor : actors) {
			graph.addActor(actor);
		}

		for (String movie : movies.keySet()) {
			ArrayList<String> movieActors = movies.get(movie);
			for (int i = 0; i < movieActors.size(); i++) {
				for (int j = i+1; j < movieActors.size(); j++) {
					graph.addEdge(movieActors.get(i), movieActors.get(j));
				}
			}
		}

		Scanner input = new Scanner(System.in);
		try {
			System.out.print("Actor 1 name: ");
			String actor1 = input.nextLine();
			if (!actors.contains(actor1)) {
				throw new Exception("No such actor.");
			}
			System.out.print("Actor 2 name: ");
			String actor2 = input.nextLine();
			if (!actors.contains(actor2)) {
				throw new Exception("No such actor.");
			}
			ArrayList<String> path = graph.shortestPath(actor1, actor2);
			if (path == null) {
				System.out.println("No such path between the actors.");
			}
			else {
				System.out.println("Path between "+actor1+" and "+actor2+": ");
				for (int i = 0; i < path.size(); i++) {
					if (i != path.size() - 1) {
						System.out.print(path.get(i) + " --> ");
					} else {
						System.out.print(path.get(i));
					}
				}
			}
		} catch (Exception e) {
			System.out.println(e.getMessage());
		} finally {
			input.close();
		}
	}
}